/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.to.BackupPolicyTO;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesBeSkippedAsPerPolicy {
    private static Logger logger = LoggerFactory.getLogger(FilesBeSkippedAsPerPolicy.class);
    static BackUpFolderDAOImpl backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
    private static BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
    private static boolean isFileTobeSkipped;
    public static long allowedSize;
    public static String extensions;
    private static boolean legalHoldEnabled;
    private static boolean backupSystemFilesEnabled;

    private FilesBeSkippedAsPerPolicy() {
    }

    public static boolean checkVariousPolicies(File file) {
        isFileTobeSkipped = true;
        List<String> excludedFoldersFromPolicy = backupPolicyDAOImpl.getExcludedFoldersList();
        FilesBeSkippedAsPerPolicy.skipExcludedFolders(excludedFoldersFromPolicy, file.getAbsolutePath());
        if (!isFileTobeSkipped) {
            isFileTobeSkipped = true;
            FilesBeSkippedAsPerPolicy.checkExtensions(file);
            if (!isFileTobeSkipped) {
                isFileTobeSkipped = true;
                FilesBeSkippedAsPerPolicy.checkFileSize(file, allowedSize);
            }
        }
        return isFileTobeSkipped;
    }

    public static boolean skipExcludedFolders(List<String> excludedFoldersFromPolicy, String recivedFolderPath) {
        isFileTobeSkipped = false;
        String folderPath = recivedFolderPath;
        for (String excludedFolderFromPolicy : excludedFoldersFromPolicy) {
            File fileTobeExcluded = new File(excludedFolderFromPolicy);
            excludedFolderFromPolicy = fileTobeExcluded.getAbsolutePath();
            while (excludedFolderFromPolicy.endsWith("/") || excludedFolderFromPolicy.endsWith("\\")) {
                excludedFolderFromPolicy = excludedFolderFromPolicy.substring(0, excludedFolderFromPolicy.length() - 1);
            }
            if (SettingHelper.getOsName().toLowerCase().contains("mac")) {
                folderPath = FilesBeSkippedAsPerPolicy.checkForMacBasePath(folderPath);
            }
            boolean sameFolder = folderPath.equalsIgnoreCase(excludedFolderFromPolicy);
            boolean childFolder = folderPath.toLowerCase().contains(excludedFolderFromPolicy.toLowerCase() + StringLiterals.FILE_SEPARATOR);
            if (!sameFolder && !childFolder) continue;
            logger.info(" Excluded Folder:" + folderPath);
            isFileTobeSkipped = true;
            return isFileTobeSkipped;
        }
        return isFileTobeSkipped;
    }

    public static void checkExtensions(File file) {
        boolean isExtAllowed;
        String[] tmpExtensionCheck = null;
        if (!StringUtils.isEmpty((String)extensions)) {
            String delimiter = ",";
            tmpExtensionCheck = extensions.split(delimiter);
        }
        if (!StringUtils.isEmpty((String)extensions) && (isExtAllowed = FilesBeSkippedAsPerPolicy.isExtensionAllowedForBackup(tmpExtensionCheck, file))) {
            isFileTobeSkipped = false;
        }
    }

    private static boolean isExtensionAllowedForBackup(String[] tmpExtensionCheck, File file) {
        String fileext = FilenameUtils.getExtension((String)file.getName());
        boolean fileAllowedForBackup = false;
        for (String ext : tmpExtensionCheck) {
            if ("ALL".equalsIgnoreCase(ext = ext.trim())) {
                fileAllowedForBackup = true;
                break;
            }
            if (!ext.equalsIgnoreCase(fileext)) continue;
            fileAllowedForBackup = true;
            break;
        }
        return fileAllowedForBackup;
    }

    private static void checkFileSize(File file, long allowedSize) {
        if (allowedSize != 0L && allowedSize != -1L) {
            long fileSizeinBytes = file.length();
            float fileSizeinMb = (float)fileSizeinBytes / 1048576.0f;
            if (fileSizeinMb <= (float)allowedSize) {
                isFileTobeSkipped = false;
            }
        } else if (allowedSize == -1L) {
            isFileTobeSkipped = false;
        }
    }

    public static long getCurrentPolicyMaxSize() {
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List<BackupPolicyTO> currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        BackupPolicyTO currentPolicy = null;
        if (currentDetails != null && !currentDetails.isEmpty()) {
            if (!"".equals(NotificationHelper.getCurrentPolicyName())) {
                for (BackupPolicyTO bkpPolicy : currentDetails) {
                    if (!bkpPolicy.getPolicyGroupName().equals(NotificationHelper.getCurrentPolicyName())) continue;
                    currentPolicy = bkpPolicy;
                }
            } else {
                currentPolicy = currentDetails.get(0);
            }
        }
        if (currentPolicy != null) {
            return currentPolicy.getMaxFileSize();
        }
        return 0L;
    }

    public static void setLegalHoldDetails() {
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List<BackupPolicyTO> currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        BackupPolicyTO currentPolicy = null;
        if (currentDetails != null && !currentDetails.isEmpty()) {
            if (!"".equals(NotificationHelper.getCurrentPolicyName())) {
                for (BackupPolicyTO bkpPolicy : currentDetails) {
                    if (!bkpPolicy.getPolicyGroupName().equals(NotificationHelper.getCurrentPolicyName())) continue;
                    currentPolicy = bkpPolicy;
                }
            } else {
                currentPolicy = currentDetails.get(0);
            }
            if (currentPolicy != null && !StringUtils.isEmpty((String)currentPolicy.getLegalHoldEnabled())) {
                FilesBeSkippedAsPerPolicy.setLegalHoldEnabled(Boolean.parseBoolean(currentPolicy.getLegalHoldEnabled()));
            }
            if (currentPolicy != null && !StringUtils.isEmpty((String)currentPolicy.getBackupSystemFilesEnabled())) {
                FilesBeSkippedAsPerPolicy.setBackupSystemFilesEnabled(Boolean.parseBoolean(currentPolicy.getBackupSystemFilesEnabled()));
            }
        }
    }

    public static boolean checkPstExtension(File file) {
        boolean isFileBeskipped = false;
        String pstExtension = "pst";
        String ostExtension = "ost";
        String fileext = FilenameUtils.getExtension((String)file.getName());
        if (pstExtension.equalsIgnoreCase(fileext) || ostExtension.equalsIgnoreCase(fileext)) {
            isFileBeskipped = true;
        }
        return isFileBeskipped;
    }

    public static long getAllowedSize() {
        return allowedSize;
    }

    public static void setAllowedSize(long allowedSize) {
        FilesBeSkippedAsPerPolicy.allowedSize = allowedSize;
    }

    public static String getExtensions() {
        return extensions;
    }

    public static void setExtensions(String extensions) {
        FilesBeSkippedAsPerPolicy.extensions = extensions;
    }

    private static String checkForMacBasePath(String completeParentPath) {
        String mac = "Macintosh";
        if (completeParentPath.startsWith("Macintosh" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(9);
        }
        return completeParentPath;
    }

    public static boolean isLegalHoldEnabled() {
        return legalHoldEnabled;
    }

    public static void setLegalHoldEnabled(boolean legalHoldEnabled) {
        FilesBeSkippedAsPerPolicy.legalHoldEnabled = legalHoldEnabled;
    }

    public static boolean isBackupSystemFilesEnabled() {
        return backupSystemFilesEnabled;
    }

    public static void setBackupSystemFilesEnabled(boolean backupSystemFilesEnabled) {
        FilesBeSkippedAsPerPolicy.backupSystemFilesEnabled = backupSystemFilesEnabled;
    }

    static {
        legalHoldEnabled = false;
        backupSystemFilesEnabled = false;
    }
}

