/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.dao.RestoreActivityDAO;
import com.parablu.epa.core.to.RestoreActivityTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreActivityHistoryDAOImpl
extends BaseDAO
implements RestoreActivityDAO {
    private Logger logger = LoggerFactory.getLogger(RestoreActivityHistoryDAOImpl.class);
    private static final String SELECTFROM = "select * from ";

    public RestoreActivityHistoryDAOImpl(String uRL) {
        super(uRL);
    }

    public boolean createRestoreActivityHistoryDB() {
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnectionForCreatingDatabase();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(BluSyncSQLConstants.CREATE_RESTORE_ACTIVITY_TABLE_QUERY);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("sqlExeception in CREATE__RESTORE_ACTIVITY_TABLE" + e);
            }
        }
        this.closeConnection();
        return success;
    }

    public boolean addEventToRestoreActivity(RestoreActivityTO activityTO) {
        String tempActivityBatchStatus = activityTO.getRestoreBatchStatus();
        String tempActivityBatchId = activityTO.getRestoreBatchId();
        String sqlQuery = new StringBuffer().append("INSERT INTO ").append("RestoreActivityHistory").append(" (").append("restoreBatchStatus").append(",").append("restoreBatchID").append(")").append(" Values(?,?);").toString();
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery, 1);
                this.statement.setString(1, tempActivityBatchStatus);
                this.statement.setString(2, tempActivityBatchId);
                this.statement.execute();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while inserting into Restore Activity Table" + e);
            }
        }
        this.closeConnection();
        return success;
    }

    public boolean updateEventToRestoreActivityHistoryTable(RestoreActivityTO activityTO) {
        String restoreBatchId = activityTO.getRestoreBatchId();
        String restoreBatchStatus = activityTO.getRestoreBatchStatus();
        String sqlQuery = "Update RestoreActivityHistory set restoreBatchStatus=? where restoreBatchID=?;";
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("Update RestoreActivityHistory set restoreBatchStatus=? where restoreBatchID=?;");
                this.statement.setString(1, restoreBatchStatus);
                this.statement.setString(2, restoreBatchId);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("SQLException while updating restore activity Table" + e.getMessage());
            }
        }
        this.closeConnection();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestoreActivityTO getCurrentStatusFromRestoreActivityHistoryTable() {
        String sqlQuery = new StringBuffer().append(SELECTFROM).append("RestoreActivityHistory").append(" order by ").append("restoreBatchID").append(" DESC LIMIT 1").toString();
        this.statement = null;
        ResultSet getcurNameRes = null;
        RestoreActivityTO currentActivity = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                getcurNameRes = this.statement.executeQuery();
                if (getcurNameRes != null && getcurNameRes.next()) {
                    currentActivity = new RestoreActivityTO();
                    currentActivity.setRestoreBatchStatus(getcurNameRes.getString("restoreBatchStatus"));
                    currentActivity.setRestoreBatchId(getcurNameRes.getString("restoreBatchID"));
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while selecting from restore activity Table" + e);
            }
            finally {
                if (getcurNameRes != null) {
                    try {
                        getcurNameRes.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set getcurNameRes in restore actvity" + e);
                    }
                }
            }
            getcurNameRes = null;
            this.closeConnection();
        }
        return currentActivity;
    }
}

