/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.dao.BackupStatisticsDAO;
import com.parablu.epa.core.to.BackUpStatFileTO;
import com.parablu.epa.core.to.BackupTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupStatisticsDAOImpl
extends BaseDAO
implements BackupStatisticsDAO {
    private Logger logger = LoggerFactory.getLogger(BackUpFolderDAOImpl.class);
    private static final String DELETEFROM = "delete from ";
    private static final String SQLEXCEPTION_WHILE_INSERTING_LISTOF_PARENTFOLDERS = "SQLException while inserting list of parent folders";

    public BackupStatisticsDAOImpl(String uRL) {
        super(uRL);
    }

    public boolean createBackupStatisticsTable() {
        String query = BluSyncSQLConstants.CREATE_BACKUP_STATISTICS_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while creating backup Staitstics table", (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    public boolean insertFileNameIntoTable(BackupTO backupTO) {
        String query = "insert into BKUP_STAT(filename,filepath,size,status) values(?,?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into BKUP_STAT(filename,filepath,size,status) values(?,?,?,?);");
                this.statement.setString(1, backupTO.getFileName());
                this.statement.setString(2, backupTO.getAbstractFilePath());
                this.statement.setString(3, String.valueOf(backupTO.getFileSize()));
                this.statement.setString(4, "Failed");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while inserting parent folder into backup statics table", (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackUpStatFileTO> getBackUpFiles() {
        String query = "select * from BKUP_STAT";
        ArrayList<BackUpStatFileTO> files = null;
        this.statement = null;
        ResultSet resultSet = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("select * from BKUP_STAT");
                resultSet = this.statement.executeQuery();
                files = new ArrayList<BackUpStatFileTO>();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        BackUpStatFileTO backUpStatFileTO = new BackUpStatFileTO();
                        backUpStatFileTO.setFileName(resultSet.getString("filename"));
                        backUpStatFileTO.setFilePath(resultSet.getString("filepath"));
                        backUpStatFileTO.setSize(Long.valueOf(resultSet.getString("size")).longValue());
                        backUpStatFileTO.setFileStatus(resultSet.getString("status"));
                        backUpStatFileTO.setFailedReason(resultSet.getString("failedreason"));
                        files.add(backUpStatFileTO);
                    }
                }
            }
            catch (SQLException exception) {
                this.logger.trace("" + exception);
                this.logger.error("SQLException while selcting from backup statics table", (Object)exception.getMessage());
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set for geting backup files" + e);
                    }
                }
            }
            this.closeConnection();
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountOfTable() {
        String query = "SELECT COUNT(*) FROM BKUP_STAT";
        this.statement = null;
        ResultSet resultSet = null;
        int count = 0;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("SELECT COUNT(*) FROM BKUP_STAT");
                resultSet = this.statement.executeQuery();
                while (resultSet.next()) {
                    count = resultSet.getInt(1);
                }
                resultSet.close();
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while selcting from backup statistics table", (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException exception) {
                        this.logger.error("SQLException while closing result set for selcting from backup statistics table" + exception);
                    }
                }
            }
            this.closeConnection();
        }
        return count;
    }

    public boolean clearEntireTable() {
        String query = "delete from BKUP_STAT";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from BKUP_STAT");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while deleting from backup statics table", (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    public boolean insertListOfFileNamesIntoTable(List<BackupTO> backupTOs) {
        String query = "insert into BKUP_STAT(filename,filepath,size,status) values(?,?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into BKUP_STAT(filename,filepath,size,status) values(?,?,?,?);");
                int listsize = backupTOs.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    if (backupTOs.get(recordCount).isFolder()) continue;
                    this.statement.setString(1, backupTOs.get(recordCount).getFileName());
                    this.statement.setString(2, backupTOs.get(recordCount).getAbstractFilePath());
                    this.statement.setString(3, String.valueOf(backupTOs.get(recordCount).getFileSize()));
                    this.statement.setString(4, "Failed");
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_INSERTING_LISTOF_PARENTFOLDERS, (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    public boolean updateStatusForListOfFileNamesIntoTable(List<BackupTO> backupTOs) {
        String completed = "Uploaded";
        String query = "Update BKUP_STAT set status=?  where filepath=?  AND filename=?;";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("Update BKUP_STAT set status=?  where filepath=?  AND filename=?;");
                int listsize = backupTOs.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, completed);
                    this.statement.setString(2, backupTOs.get(recordCount).getAbstractFilePath());
                    this.statement.setString(3, backupTOs.get(recordCount).getFileName());
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while inserting list of parent folders into backup statics table:", (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    public boolean updateStatusFileNameIntoTable(BackupTO file) {
        String completed = "Uploaded";
        String query = "Update BKUP_STAT set status=?  where filepath=?  AND filename=?;";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("Update BKUP_STAT set status=?  where filepath=?  AND filename=?;");
                this.statement.setString(1, completed);
                this.statement.setString(2, file.getAbstractFilePath());
                this.statement.setString(3, file.getFileName());
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_INSERTING_LISTOF_PARENTFOLDERS, (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    public boolean updateFailedStatusFileNameIntoTable(BackupTO file, String reason) {
        String query = "Update BKUP_STAT set failedreason=?  where filepath=?  AND filename=?;";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("Update BKUP_STAT set failedreason=?  where filepath=?  AND filename=?;");
                this.statement.setString(1, reason);
                this.statement.setString(2, file.getAbstractFilePath());
                this.statement.setString(3, file.getFileName());
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_INSERTING_LISTOF_PARENTFOLDERS, (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    public boolean alterTable() {
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnectionForCreatingDatabase();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("ALTER table BKUP_STAT ADD COLUMN failedreason TEXT;");
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("sqlExeception in creating activity table" + e);
            }
        }
        this.closeConnection();
        return success;
    }
}

