/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.constant.CrawlLifecycle;
import com.parablu.epa.core.dao.ActivityHistoryDAO;
import com.parablu.epa.core.to.ActivityTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityHistoryImpl
extends BaseDAO
implements ActivityHistoryDAO {
    private Logger logger = LoggerFactory.getLogger(ActivityHistoryImpl.class);
    private static final String SELECTFROM = "select * from ";
    private static final String WHERE = " where ";
    private static final String ORDERBY = " ORDER BY ";

    public ActivityHistoryImpl(String uRL) {
        super(uRL);
    }

    public boolean createActivityHistoryDB() {
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnectionForCreatingDatabase();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(BluSyncSQLConstants.CREATE_ACTIVITY_TABLE_WINDOWS_QUERY);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("sqlExeception creating Activity history DB:" + e);
            }
        }
        this.closeConnection();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addEventToActivityHistoryTable(ActivityTO activity) {
        long columnId = 0L;
        String tempActivityName = activity.getActivityName();
        String tempActivityTimeStamp = String.valueOf(activity.getActivityTimeStamp().getTime());
        String tempActivityUpload = activity.getUploadCount();
        String tempActivitydownload = activity.getDownloadCount();
        String batchId = activity.getBatchId();
        String sqlQuery = new StringBuffer().append("INSERT INTO ").append("ActivityHistory").append(" (").append("batchID").append(",").append("timestamp").append(",").append("currentactivity").append(",").append("uploadcount").append(",").append("downloadcount").append(")").append(" Values(?,?,?,?,?);").toString();
        ResultSet result = null;
        this.statement = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery, 1);
                this.statement.setString(1, batchId);
                this.statement.setString(2, tempActivityTimeStamp);
                this.statement.setString(3, tempActivityName);
                this.statement.setString(4, tempActivityUpload);
                this.statement.setString(5, tempActivitydownload);
                this.statement.execute();
                result = this.statement.getGeneratedKeys();
                if (result != null && result.next()) {
                    columnId = result.getLong(1);
                    result.close();
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while inserting into Activity Table" + e);
            }
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set" + e);
                    }
                }
            }
        }
        this.closeConnection();
        return columnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityTO getCurrentStatusFromActivityHistoryTable() {
        String sqlQuery = new StringBuffer().append(SELECTFROM).append("ActivityHistory").append(ORDERBY).append("id").append(" DESC LIMIT 1").toString();
        this.statement = null;
        ResultSet getcurNameRes = null;
        ActivityTO currentActivity = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                getcurNameRes = this.statement.executeQuery();
                if (getcurNameRes != null && getcurNameRes.next()) {
                    String tempTimseStamp = getcurNameRes.getString("timestamp");
                    currentActivity = new ActivityTO();
                    currentActivity.setActivityName(getcurNameRes.getString("currentactivity"));
                    currentActivity.setBatchId(getcurNameRes.getString("batchID"));
                    Date date = new Date(Long.valueOf(tempTimseStamp));
                    currentActivity.setActivityTimeStamp(date);
                    currentActivity.setUploadCount(getcurNameRes.getString("uploadcount"));
                    currentActivity.setDownloadCount(getcurNameRes.getString("downloadcount"));
                    currentActivity.setActivityID((long)getcurNameRes.getInt("id"));
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while selecting from activity Table" + e);
            }
            finally {
                if (getcurNameRes != null) {
                    try {
                        getcurNameRes.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set getcurNameRes:" + e);
                    }
                }
            }
            getcurNameRes = null;
            this.closeConnection();
        }
        return currentActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanActivityHistoryTable() {
        this.statement = null;
        ActivityTO activity = this.getlastSuccessfullEntryFromActivityHistoryTable();
        String sqlStatement = "select count(*) AS recordCount from ActivityHistory";
        long lastSuccessfulCrawl = 0L;
        if (activity != null && activity.getActivityTimeStamp() != null) {
            lastSuccessfulCrawl = activity.getActivityTimeStamp().getTime();
        }
        String sqlDeleteStatement = "delete from ActivityHistory where timestamp not in (select timestamp from ActivityHistory ORDER BY timestamp DESC LIMIT 10000) and timestamp !=" + lastSuccessfulCrawl + ";";
        ResultSet rs = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlStatement);
                rs = this.statement.executeQuery();
                long rowCount = 0L;
                if (rs != null && rs.next()) {
                    rowCount = Long.valueOf(rs.getString("recordCount"));
                    rs.close();
                }
                this.logger.debug("Number of current records is :" + rowCount);
                if (rowCount > 10000L) {
                    this.statement.execute(sqlDeleteStatement);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while cleaning activity table", (Throwable)e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException in cleaning activity table while closing result set: " + e);
                    }
                }
            }
        }
        this.closeConnection();
        return false;
    }

    public boolean dropActivityHistoryTable() {
        String sqlQuery = "drop table ActivityHistory";
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("drop table ActivityHistory");
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("SQLException while dropping activity Table" + e.getMessage());
            }
            this.closeConnection();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActivityTO> getAllHistoryActivityHistoryTable() {
        String sqlQuery = "select * from ActivityHistory";
        this.statement = null;
        ResultSet selectImageTableResult = null;
        ArrayList<ActivityTO> listOfActivities = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                selectImageTableResult = this.statement.executeQuery();
                listOfActivities = new ArrayList<ActivityTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    ActivityTO tempActivity = new ActivityTO();
                    String tempActivityUploadCount = null;
                    String tempActivityDownloadCount = null;
                    String tempActivityName = selectImageTableResult.getString("currentactivity");
                    String tempTimeStamp = selectImageTableResult.getString("timestamp");
                    Date date = new Date(Long.valueOf(tempTimeStamp));
                    tempActivityUploadCount = selectImageTableResult.getString("uploadcount");
                    tempActivityDownloadCount = selectImageTableResult.getString("downloadcount");
                    tempActivity.setActivityName(tempActivityName);
                    tempActivity.setActivityTimeStamp(date);
                    tempActivity.setUploadCount(tempActivityUploadCount);
                    tempActivity.setDownloadCount(tempActivityDownloadCount);
                    tempActivity.setActivityID((long)selectImageTableResult.getInt("id"));
                    listOfActivities.add(tempActivity);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while getAllHistory Activity History Table" + e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException in getAllHistory while closing result set ImageTable" + e);
                    }
                }
            }
        }
        this.closeConnection();
        return listOfActivities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActivityTO> getSelectRecordsFromHistoryActivityHistoryTable(boolean order, long firstIndex, long lastIndex) {
        String sqlQuery = null;
        sqlQuery = order ? new StringBuffer().append(SELECTFROM).append("ActivityHistory").append(ORDERBY).append("id").append(" DESC LIMIT ").append(firstIndex).append(",").append(lastIndex).toString() : new StringBuffer().append(SELECTFROM).append("ActivityHistory").append(ORDERBY).append("id").append(" ASC LIMIT ").append(firstIndex).append(",").append(lastIndex).toString();
        this.statement = null;
        ResultSet selectImageTableResult = null;
        ArrayList<ActivityTO> listOfActivities = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                selectImageTableResult = this.statement.executeQuery();
                listOfActivities = new ArrayList<ActivityTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    ActivityTO tempActivity = new ActivityTO();
                    String tempActivityUploadCount = null;
                    String tempActivityDownloadCount = null;
                    String tempActivityName = selectImageTableResult.getString("currentactivity");
                    String tempTimeStamp = selectImageTableResult.getString("timestamp");
                    Date date = new Date(Long.valueOf(tempTimeStamp));
                    tempActivityUploadCount = selectImageTableResult.getString("uploadcount");
                    tempActivityDownloadCount = selectImageTableResult.getString("downloadcount");
                    tempActivity.setActivityName(tempActivityName);
                    tempActivity.setActivityTimeStamp(date);
                    tempActivity.setUploadCount(tempActivityUploadCount);
                    tempActivity.setDownloadCount(tempActivityDownloadCount);
                    tempActivity.setActivityID((long)selectImageTableResult.getInt("id"));
                    listOfActivities.add(tempActivity);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException in getSelectRecordsFromHistoryActivityHistoryTable" + e);
                this.logger.error(sqlQuery);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set ImageTable" + e);
                    }
                }
            }
        }
        this.closeConnection();
        return listOfActivities;
    }

    public boolean updateEventToActivityHistoryTable(ActivityTO activity) {
        long activityId = activity.getActivityID();
        String tempActivityUpload = activity.getUploadCount();
        String tempActivitydownload = activity.getDownloadCount();
        String activityName = activity.getActivityName();
        String sqlQuery = "Update ActivityHistory set uploadcount=?,downloadcount=?,currentactivity=? where id=?;";
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("Update ActivityHistory set uploadcount=?,downloadcount=?,currentactivity=? where id=?;");
                this.statement.setString(1, tempActivityUpload);
                this.statement.setString(2, tempActivitydownload);
                this.statement.setString(3, activityName);
                this.statement.setLong(4, activityId);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("SQLException while updating activity history Table:" + e.getMessage());
            }
        }
        this.closeConnection();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityTO getlastSuccessfullEntryFromActivityHistoryTable() {
        String sqlQuery = new StringBuffer().append(SELECTFROM).append("ActivityHistory").append(WHERE).append("currentactivity").append(" =\"").append(CrawlLifecycle.FINISHED.name()).append("\" ORDER BY ").append("id").append(" DESC LIMIT 1").toString();
        this.statement = null;
        ResultSet getcurNameRes = null;
        ActivityTO currentActivity = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                getcurNameRes = this.statement.executeQuery();
                if (getcurNameRes != null && getcurNameRes.next()) {
                    String tempTimseStamp = getcurNameRes.getString("timestamp");
                    currentActivity = new ActivityTO();
                    currentActivity.setActivityName(getcurNameRes.getString("currentactivity"));
                    Date date = new Date(Long.valueOf(tempTimseStamp));
                    currentActivity.setActivityTimeStamp(date);
                    currentActivity.setUploadCount(getcurNameRes.getString("uploadcount"));
                    currentActivity.setDownloadCount(getcurNameRes.getString("downloadcount"));
                    currentActivity.setActivityID((long)getcurNameRes.getInt("id"));
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.debug("" + e);
                this.logger.error("SQLException while getting last entry from activity table:" + e.getMessage());
            }
            finally {
                if (getcurNameRes != null) {
                    try {
                        getcurNameRes.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set" + e);
                    }
                }
            }
            getcurNameRes = null;
            this.closeConnection();
        }
        return currentActivity;
    }
}

