/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter.pcb;

import com.parablu.epa.core.adapter.BaseAdapter;
import com.parablu.epa.core.exception.CrawlAdapterException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAdapter
extends BaseAdapter {
    private Logger logger = LoggerFactory.getLogger(SearchAdapter.class);

    public SearchAdapter(String cloudName, String keyStorePath) {
        super(cloudName, keyStorePath);
    }

    public SearchAdapter(InputStream inputStream, String cloudName) {
        super(inputStream, cloudName);
    }

    public String searchForfile(String fileName, String iP, Integer port, int start, int rows) throws CrawlAdapterException {
        int responseCode = 0;
        HttpResponse response = null;
        HttpGet httpget = null;
        HttpEntity responseEntity = null;
        String responseXmlAsString = null;
        try {
            URI uri = port != null ? this.formHttpsUri(iP, port, "/paracloud/cloud" + this.cloudName + "/search/file/") : this.formHttpsUri(iP, "/paracloud/cloud" + this.cloudName + "/search/file/");
            this.logger.trace(uri.toString());
            httpget = new HttpGet(uri);
            httpget.setHeader("file-name", fileName);
            httpget.setHeader("start", String.valueOf(start));
            httpget.setHeader("rows", String.valueOf(rows));
            response = this.httpclient.execute((HttpUriRequest)httpget);
            responseCode = response.getStatusLine().getStatusCode();
            this.logger.debug("responseCode: " + responseCode);
            if (responseCode == 200) {
                responseEntity = response.getEntity();
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
            }
        }
        catch (ClientProtocolException e) {
            this.logger.error("ClientProtocol Exception " + e.getMessage());
            throw new CrawlAdapterException("Exception " + e, e);
        }
        catch (IOException e) {
            this.logger.error("IOException Exception " + e.getMessage());
            throw new CrawlAdapterException("Exception " + e, e);
        }
        this.logger.debug("The response code is" + responseCode);
        if (responseCode == 200 || responseCode == 409 || responseCode == 401) {
            // empty if block
        }
        this.logger.debug("No Exception thrown");
        if (response.getEntity().isStreaming()) {
            try {
                response.getEntity().getContent().close();
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error(e.getMessage());
            }
        }
        this.logger.debug(responseXmlAsString);
        return responseXmlAsString;
    }
}

