/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper;

import com.parablu.epa.core.helper.FileSystemUtility;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.helper.utils.MD5Generator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacFileSystemUtility
extends FileSystemUtility {
    private Logger logger = LoggerFactory.getLogger(MacFileSystemUtility.class);
    private static final String MAC = "Macintosh";

    public List<BackupTO> crawlFolderEfficientStoringFullPaths(String completeParentPath, Map<String, Long> fileHashMap) {
        ArrayList<BackupTO> crawledfilesTOList = null;
        Boolean checkList = true;
        String fullParentPath = MacFileSystemUtility.checkForMacBasePath((String)completeParentPath);
        File currentFolder = new File(fullParentPath);
        File[] childFileAndFolderNames = currentFolder.listFiles();
        if (childFileAndFolderNames == null) {
            return crawledfilesTOList;
        }
        Arrays.sort(childFileAndFolderNames, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        if (fileHashMap == null || fileHashMap.isEmpty()) {
            checkList = false;
        }
        int noOfChildFilesAndFolders = childFileAndFolderNames.length;
        this.logger.debug("The number of sub directories and files in the parent directory (crawlFolderEfficientStoringFullPaths):" + childFileAndFolderNames.length);
        this.logger.debug("The parent directory is :" + currentFolder.getName());
        crawledfilesTOList = new ArrayList<BackupTO>();
        for (int i = 0; i < noOfChildFilesAndFolders; ++i) {
            List<BackupTO> curFileTOList;
            Long prevModifiedValue;
            boolean isfileHidden;
            File currentProcessingFile = childFileAndFolderNames[i];
            boolean bl = isfileHidden = currentProcessingFile.isHidden() || currentProcessingFile.getName().startsWith(".");
            if (isfileHidden) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            String absPath = currentProcessingFile.getAbsolutePath();
            if (checkList.booleanValue() && !isFileADirectory && (prevModifiedValue = fileHashMap.get(absPath)) != null && prevModifiedValue.equals(currentProcessingFile.lastModified())) {
                this.logger.debug("skipping file " + absPath);
                continue;
            }
            String completePath = absPath;
            String blackNameList = "[*!@^&{}<>|\\\"]";
            Pattern r = Pattern.compile(blackNameList);
            Matcher matcher = r.matcher(currentProcessingFile.getName());
            String fileName = matcher.find() ? matcher.replaceAll("~") : currentProcessingFile.getName();
            completePath = completePath.substring(0, completePath.length() - (fileName.length() + 1));
            String md5Value = isFileADirectory ? "null" : MD5Generator.generateMD5OfFile((File)currentProcessingFile);
            BackupTO tempFileTO = new BackupTO();
            tempFileTO.setExists(true);
            tempFileTO.setAbstractFilePath(this.createParentPathForMac(completePath));
            tempFileTO.setFileName(fileName);
            tempFileTO.setFolder(isFileADirectory);
            tempFileTO.setLastModifiedTimestamp(currentProcessingFile.lastModified());
            tempFileTO.setMd5checksum(md5Value);
            tempFileTO.setMetaData("null");
            tempFileTO.setClientData(absPath);
            tempFileTO.setBaseFolder(false);
            crawledfilesTOList.add(tempFileTO);
            if (!isFileADirectory || (curFileTOList = this.crawlFolderEfficientStoringFullPaths(currentProcessingFile.getAbsolutePath(), fileHashMap)) == null) continue;
            crawledfilesTOList.addAll(curFileTOList);
        }
        return crawledfilesTOList;
    }

    private String createParentPathForMac(String completePath) {
        return MAC + completePath;
    }
}

