/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.helper;

import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.BackupElement;
import com.parablu.epa.core.element.BackupFilesStatElement;
import com.parablu.epa.core.element.CloudInfoElement;
import com.parablu.epa.core.element.DeviceElement;
import com.parablu.epa.core.element.DeviceListElement;
import com.parablu.epa.core.element.FileElement;
import com.parablu.epa.core.element.FolderDeviceElement;
import com.parablu.epa.core.element.FolderDeviceListElement;
import com.parablu.epa.core.element.FolderInfoElement;
import com.parablu.epa.core.element.KeyValueElement;
import com.parablu.epa.core.element.MediaElement;
import com.parablu.epa.core.element.MiniCloudElement;
import com.parablu.epa.core.element.RenamedElement;
import com.parablu.epa.core.to.BackUpCrawlFileTO;
import com.parablu.epa.core.to.BackUpStatFileTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.CloudStorageTO;
import com.parablu.epa.core.to.DedupTO;
import com.parablu.epa.core.to.DeviceTo;
import com.parablu.epa.core.to.FileTO;
import com.parablu.epa.core.to.MediaTO;
import com.parablu.epa.core.to.MiniCloudTO;
import com.parablu.epa.core.to.RenamedTO;
import com.parablu.epa.helper.utils.MD5Generator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectUtils {
    private static Logger logger = LoggerFactory.getLogger(ObjectUtils.class);
    private static final String EXCEPTION = "Exception :";
    private static final String OS_NAME = "os.name";

    private ObjectUtils() {
    }

    public static void copyFileTOtoFileElement(FileTO fileTO, FileElement fileElement) {
        if (fileTO != null && fileElement != null) {
            fileElement.setExists(fileTO.isExists());
            fileElement.setFileCompletePath(fileTO.getAbstractFilePath());
            fileElement.setFileName(fileTO.getFileName());
            fileElement.setFolder(fileTO.isFolder());
            fileElement.setLastModifiedTimestamp(fileTO.getLastModifiedTimestamp());
            fileElement.setMetaData(fileTO.getMetaData());
            fileElement.setMd5checksum(fileTO.getMd5checksum());
            fileElement.setBackupId(fileTO.getBackupId());
            fileElement.setFileRevisionId(fileTO.getFileRevisionId());
        }
    }

    public static void copyBackupTOtoBackupElement(BackupTO fileTO, BackupElement fileElement) {
        if (fileTO != null && fileElement != null) {
            fileElement.setExists(fileTO.isExists());
            fileElement.setFileCompletePath(fileTO.getAbstractFilePath());
            fileElement.setFileName(fileTO.getFileName());
            fileElement.setFolder(fileTO.isFolder());
            fileElement.setLastModifiedTimestamp(fileTO.getLastModifiedTimestamp());
            fileElement.setMetaData(fileTO.getMetaData());
            fileElement.setMd5checksum(fileTO.getMd5checksum());
            fileElement.setBaseFolder(fileTO.isBaseFolder());
            fileElement.setClientData(fileTO.getClientData());
            fileElement.setBackupId(fileTO.getBackupId());
            fileElement.setFileRevisionId(fileTO.getFileRevisionId());
        }
    }

    public static void copyBackupTOtoFileElement(BackupTO fileTO, FileElement fileElement) {
        if (fileTO != null && fileElement != null) {
            fileElement.setExists(fileTO.isExists());
            fileElement.setFileCompletePath(fileTO.getAbstractFilePath());
            fileElement.setFileName(fileTO.getFileName());
            fileElement.setFolder(fileTO.isFolder());
            fileElement.setLastModifiedTimestamp(fileTO.getLastModifiedTimestamp());
            fileElement.setMetaData(fileTO.getMetaData());
            fileElement.setMd5checksum(fileTO.getMd5checksum());
            fileElement.setBackupId(fileTO.getBackupId());
            fileElement.setSize(String.valueOf(fileTO.getFileSize()));
        }
    }

    public static void copyFileElemenToBackupTO(FileElement fileElement, BackupTO fileTO) {
        if (fileTO != null && fileElement != null) {
            fileTO.setExists(fileElement.isExists());
            fileTO.setAbstractFilePath(fileElement.getFileCompletePath());
            fileTO.setFileName(fileElement.getFileName());
            fileTO.setFolder(fileElement.isFolder());
            fileTO.setLastModifiedTimestamp(fileElement.getLastModifiedTimestamp());
            fileTO.setMetaData(fileElement.getMetaData());
            fileTO.setMd5checksum(fileElement.getMd5checksum());
            fileTO.setBackupId(fileElement.getBackupId());
        }
    }

    public static void copyMediaElemenToMediaTO(MediaElement mediaElement, MediaTO mediaTO) {
        if (mediaTO != null && mediaElement != null) {
            mediaTO.setExists(mediaElement.isExists());
            mediaTO.setAbstractFilePath(mediaElement.getFileCompletePath());
            mediaTO.setFileName(mediaElement.getFileName());
            mediaTO.setFolder(mediaElement.isFolder());
            mediaTO.setLastModifiedTimestamp(mediaElement.getLastModifiedTimestamp());
            mediaTO.setMetaData(mediaElement.getMetaData());
            mediaTO.setMd5checksum(mediaElement.getMd5checksum());
            mediaTO.setMediaType(mediaElement.getMediaType());
            mediaTO.setExtension(mediaElement.getExtension());
        }
    }

    public static void copyBackupElementToBackupTO(BackupElement fileElement, BackupTO fileTO) {
        if (fileElement != null && fileTO != null) {
            fileTO.setExists(fileElement.isExists());
            fileTO.setAbstractFilePath(fileElement.getFileCompletePath());
            fileTO.setFileName(fileElement.getFileName());
            fileTO.setFolder(fileElement.isFolder());
            fileTO.setLastModifiedTimestamp(fileElement.getLastModifiedTimestamp());
            fileTO.setMetaData(fileElement.getMetaData());
            fileTO.setMd5checksum(fileElement.getMd5checksum());
            fileTO.setBaseFolder(fileElement.isBaseFolder());
            fileTO.setClientData(fileElement.getClientData());
            fileTO.setBackupId(fileElement.getBackupId());
        }
    }

    public static void copyFileElementToFileTO(FileElement fileElement, FileTO fileTO) {
        if (fileElement != null && fileTO != null) {
            fileTO.setExists(fileElement.isExists());
            fileTO.setAbstractFilePath(fileElement.getFileCompletePath());
            fileTO.setFileName(fileElement.getFileName());
            fileTO.setFolder(fileElement.isFolder());
            fileTO.setLastModifiedTimestamp(fileElement.getLastModifiedTimestamp());
            fileTO.setMetaData(fileElement.getMetaData());
            fileTO.setMd5checksum(fileElement.getMd5checksum());
            fileTO.setBackupId(fileElement.getBackupId());
            fileTO.setFileRevisionId(fileElement.getFileRevisionId());
        }
    }

    public static void copyRenamedElementToRenamedTO(RenamedElement renamedElement, RenamedTO renamedTO) {
        if (renamedElement != null && renamedTO != null) {
            renamedTO.setExists(renamedElement.isExists());
            renamedTO.setAbstractFilePath(renamedElement.getFileCompletePath());
            renamedTO.setNewfileName(renamedElement.getNewfileName());
            renamedTO.setOldFileName(renamedElement.getOldFileName());
            renamedTO.setFolder(renamedElement.isFolder());
            renamedTO.setLastModifiedTimestamp(renamedElement.getLastModifiedTimestamp());
            renamedTO.setMetaData(renamedElement.getMetaData());
            renamedTO.setMd5checksum(renamedElement.getMd5checksum());
        }
    }

    public static void copyMiniCloudElementToMiniCloudTO(MiniCloudElement miniCloudElement, MiniCloudTO miniCloudTO) {
        if (miniCloudElement != null && miniCloudTO != null) {
            miniCloudTO.setMiniCloudId(miniCloudElement.getId());
            miniCloudTO.setMiniCloudName(miniCloudElement.getMiniCloudName());
        }
    }

    public static List<BackupTO> convertFileElementToBackupTO(List<FileElement> crawlResponseFileElement, String miniCloudId) {
        ArrayList<BackupTO> crawlResponseFileTO = new ArrayList<BackupTO>();
        try {
            for (FileElement fileElement : crawlResponseFileElement) {
                BackupTO fileto = new BackupTO();
                ObjectUtils.copyFileElemenToBackupTO(fileElement, fileto);
                fileto.setMiniCloudId(miniCloudId);
                crawlResponseFileTO.add(fileto);
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return crawlResponseFileTO;
    }

    public static List<MediaTO> convertMediaElementToMediaTO(List<MediaElement> crawlResponseMediaElement, String miniCloudId) {
        ArrayList<MediaTO> crawlResponseFileTO = new ArrayList<MediaTO>();
        try {
            for (MediaElement fileElement : crawlResponseMediaElement) {
                MediaTO mediato = new MediaTO();
                ObjectUtils.copyMediaElemenToMediaTO(fileElement, mediato);
                mediato.setMiniCloudId(miniCloudId);
                crawlResponseFileTO.add(mediato);
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return crawlResponseFileTO;
    }

    public static CloudStorageTO converToCloudStorage(CloudInfoElement cloudElement) {
        CloudStorageTO cloudStorage = new CloudStorageTO();
        List<FolderInfoElement> listFolderInfo = cloudElement.getListFolders().getFolderListElement();
        float consumeStorage = 0.0f;
        for (FolderInfoElement folderElement : listFolderInfo) {
            consumeStorage += folderElement.getSize();
        }
        cloudStorage.setConsumedStorage(consumeStorage);
        cloudStorage.setTotalSizeLimit(cloudElement.getLicense().getSizeAllowed());
        return cloudStorage;
    }

    public static List<BackupTO> convertToBackupTO(List<BackupElement> crawlResponseFileElement, String miniCloudId) {
        ArrayList<BackupTO> crawlResponseFileTO = new ArrayList<BackupTO>();
        try {
            for (BackupElement fileElement : crawlResponseFileElement) {
                BackupTO fileto = new BackupTO();
                ObjectUtils.copyBackupElementToBackupTO(fileElement, fileto);
                fileto.setMiniCloudId(miniCloudId);
                crawlResponseFileTO.add(fileto);
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return crawlResponseFileTO;
    }

    public static DeviceTo convertToDevice(DeviceElement deviceElement) {
        DeviceTo device = new DeviceTo();
        device.setDeviceName(deviceElement.getDeviceName());
        device.setDeviceId(deviceElement.getDeviceId());
        device.setDeviceUid(deviceElement.getDeviceUUID());
        device.setUserName(deviceElement.getUserName());
        device.setBlocked(deviceElement.isBlocked());
        return device;
    }

    public static List<DeviceTo> convertToDeviceList(DeviceListElement deviceList) {
        ArrayList<DeviceTo> listDevices = new ArrayList<DeviceTo>();
        List<DeviceElement> listDeviceElement = deviceList.getDeviceElementList();
        for (DeviceElement deviceElement : listDeviceElement) {
            DeviceTo deviceTo = ObjectUtils.convertToDevice(deviceElement);
            listDevices.add(deviceTo);
        }
        return listDevices;
    }

    public static DeviceTo convertToFolderDevice(FolderDeviceElement folderDeviceElement) {
        DeviceTo device = new DeviceTo();
        device.setFileName(folderDeviceElement.getFilePath());
        device.setFilePath(folderDeviceElement.getFileName());
        device.setIsBaseFolder(folderDeviceElement.getIsBaseFolder());
        device.setFolder(folderDeviceElement.getFolder());
        device.setBackupId(folderDeviceElement.getBackupId());
        device.setFileUserOwner(folderDeviceElement.getFileUserOwner());
        device.setStoragePlace(folderDeviceElement.getStoragePlace());
        device.setExists(Boolean.parseBoolean(folderDeviceElement.getExists()));
        return device;
    }

    public static List<DeviceTo> convertToFolderDeviceList(FolderDeviceListElement deviceFolderList) {
        ArrayList<DeviceTo> listFolderDevices = new ArrayList<DeviceTo>();
        List<FolderDeviceElement> listFolderDeviceElement = deviceFolderList.getFolderDeviceElementList();
        for (FolderDeviceElement folderDeviceElement : listFolderDeviceElement) {
            DeviceTo deviceTo = ObjectUtils.convertToFolderDevice(folderDeviceElement);
            listFolderDevices.add(deviceTo);
        }
        return listFolderDevices;
    }

    public static FolderDeviceElement convertToFolderDeviceElement(DeviceTo deviceTo) {
        FolderDeviceElement folderDeviceElement = new FolderDeviceElement();
        folderDeviceElement.setFileName(deviceTo.getFileName());
        return folderDeviceElement;
    }

    public static FileElement convertToFileElement(DeviceTo deviceTo) {
        FileElement fileElement = new FileElement();
        if (deviceTo.getFileName() == null) {
            fileElement.setFileCompletePath(deviceTo.getFilePath());
            fileElement.setFileName(deviceTo.getFilePath());
        } else {
            fileElement.setFileCompletePath(deviceTo.getFileName() + "/" + deviceTo.getFilePath());
            fileElement.setFileName(deviceTo.getFileName() + "/" + deviceTo.getFilePath());
        }
        return fileElement;
    }

    public static DeviceElement convertToDeviceElement(DeviceTo deviceTo) {
        DeviceElement deviceElement = new DeviceElement();
        deviceElement.setDeviceName(deviceTo.getDeviceName());
        deviceElement.setDeviceUUID(deviceTo.getDeviceUid());
        deviceElement.setDeviceId(deviceTo.getDeviceId());
        return deviceElement;
    }

    public static List<FileTO> convertToFileTO(List<FileElement> crawlResponseFileElement, String miniCloudId) {
        ArrayList<FileTO> crawlResponseFileTO = new ArrayList<FileTO>();
        try {
            for (FileElement fileElement : crawlResponseFileElement) {
                FileTO fileto = new FileTO();
                ObjectUtils.copyFileElementToFileTO(fileElement, fileto);
                fileto.setMiniCloudId(miniCloudId);
                fileto.setFileRevisionId(fileElement.getFileRevisionId());
                crawlResponseFileTO.add(fileto);
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return crawlResponseFileTO;
    }

    public static List<MiniCloudTO> convertToMiniCloudTO(List<MiniCloudElement> listMiniCloudElement) {
        ArrayList<MiniCloudTO> listMiniCloud = new ArrayList<MiniCloudTO>();
        for (MiniCloudElement miniCloudElement : listMiniCloudElement) {
            MiniCloudTO miniCloudTO = new MiniCloudTO();
            ObjectUtils.copyMiniCloudElementToMiniCloudTO(miniCloudElement, miniCloudTO);
            listMiniCloud.add(miniCloudTO);
        }
        return listMiniCloud;
    }

    public static List<RenamedTO> convertToRenamedTO(List<RenamedElement> crawlResponseRenamedElement) {
        ArrayList<RenamedTO> crawlResponseRenamedTO = new ArrayList<RenamedTO>();
        try {
            for (RenamedElement renamedElement : crawlResponseRenamedElement) {
                RenamedTO renamedTO = new RenamedTO();
                ObjectUtils.copyRenamedElementToRenamedTO(renamedElement, renamedTO);
                crawlResponseRenamedTO.add(renamedTO);
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return crawlResponseRenamedTO;
    }

    public static void copyMediaTOtoMediaElement(MediaTO fileTO, MediaElement fileElement) {
        if (fileTO != null && fileElement != null) {
            fileElement.setExists(fileTO.isExists());
            fileElement.setFileCompletePath(fileTO.getAbstractFilePath());
            fileElement.setFileName(fileTO.getFileName());
            fileElement.setFolder(fileTO.isFolder());
            fileElement.setLastModifiedTimestamp(fileTO.getLastModifiedTimestamp());
            fileElement.setMetaData(fileTO.getMetaData());
            fileElement.setMd5checksum(fileTO.getMd5checksum());
            fileElement.setExtension(fileTO.getExtension());
            fileElement.setMediaType(fileTO.getMediaType());
        }
    }

    public static List<BackupTO> createBackupElementForFileNames(List<BackUpCrawlFileTO> crawlFileTOs) {
        ArrayList<BackupTO> backupTOList = new ArrayList<BackupTO>();
        for (BackUpCrawlFileTO crawlFileTO : crawlFileTOs) {
            String absPath;
            String filePath = crawlFileTO.getCompletePath();
            File fileToBeBackedUp = new File(filePath);
            String md5FilePath = ObjectUtils.getFileSnapshotPath(filePath);
            File md5File = new File(md5FilePath);
            String completePath = absPath = fileToBeBackedUp.getAbsolutePath();
            String fileName = fileToBeBackedUp.getName();
            completePath = completePath.substring(0, completePath.length() - (fileName.length() + 1));
            boolean isFileADirectory = fileToBeBackedUp.isDirectory();
            String md5Value = isFileADirectory ? "null" : MD5Generator.generateMD5OfFile((File)md5File);
            BackupTO tempFileTO = new BackupTO();
            tempFileTO.setExists(true);
            tempFileTO.setAbstractFilePath(ObjectUtils.createParentPathForMacOrWin(completePath));
            tempFileTO.setFileName(fileName);
            tempFileTO.setFolder(isFileADirectory);
            tempFileTO.setLastModifiedTimestamp(fileToBeBackedUp.lastModified());
            tempFileTO.setMd5checksum(md5Value);
            tempFileTO.setMetaData("null");
            tempFileTO.setClientData(absPath);
            tempFileTO.setBaseFolder(false);
            tempFileTO.setFileSize(fileToBeBackedUp.length());
            backupTOList.add(tempFileTO);
        }
        return backupTOList;
    }

    public static void copyBackupStatTOtoBackupStatElement(BackUpStatFileTO fileTO, BackupFilesStatElement fileElement) {
        if (fileTO != null && fileElement != null) {
            fileElement.setFileName(fileTO.getFileName());
            fileElement.setFilePath(fileTO.getFilePath());
            fileElement.setSize(String.valueOf(fileTO.getSize()));
            fileElement.setStatus(fileTO.getFileStatus());
            fileElement.setFailedReason(fileTO.getFailedReason());
        }
    }

    public static String createParentPathForMacOrWin(String completePath) {
        String mac = "Macintosh";
        String osType = System.getProperty(OS_NAME);
        if (osType.toLowerCase().contains("mac")) {
            return "Macintosh" + completePath;
        }
        if (osType.toLowerCase().contains("linux")) {
            return "ROOT" + completePath;
        }
        return completePath;
    }

    public static List<DedupTO> convertKeyValueElementToDedupTO(List<KeyValueElement> keyValueElement) {
        ArrayList<DedupTO> dedupFileTO = new ArrayList<DedupTO>();
        try {
            for (KeyValueElement fileElement : keyValueElement) {
                DedupTO fileto = new DedupTO();
                ObjectUtils.copyKeyValueElemenToDedupTO(fileElement, fileto);
                dedupFileTO.add(fileto);
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return dedupFileTO;
    }

    public static void copyKeyValueElemenToDedupTO(KeyValueElement keyValueElement, DedupTO dedupTO) {
        if (dedupTO != null && keyValueElement != null) {
            dedupTO.setMd5Value(keyValueElement.getKey());
            dedupTO.setBackupId(keyValueElement.getValue());
        }
    }

    public static List<BackupTO> createBackupElementForFiles(List<File> files) {
        ArrayList<BackupTO> backupTOList = new ArrayList<BackupTO>();
        for (File file : files) {
            String absPath;
            String completePath = absPath = file.getAbsolutePath();
            String fileName = file.getName();
            String md5FilePath = ObjectUtils.getFileSnapshotPath(absPath);
            File md5File = new File(md5FilePath);
            completePath = completePath.substring(0, completePath.length() - (fileName.length() + 1));
            boolean isFileADirectory = file.isDirectory();
            String md5Value = isFileADirectory ? "null" : MD5Generator.generateMD5OfFile((File)md5File);
            BackupTO tempFileTO = new BackupTO();
            tempFileTO.setExists(true);
            tempFileTO.setAbstractFilePath(ObjectUtils.createParentPathForMacOrWin(completePath));
            tempFileTO.setFileName(fileName);
            tempFileTO.setFolder(isFileADirectory);
            tempFileTO.setLastModifiedTimestamp(file.lastModified());
            tempFileTO.setMd5checksum(md5Value);
            tempFileTO.setMetaData("null");
            tempFileTO.setClientData(absPath);
            tempFileTO.setBaseFolder(false);
            tempFileTO.setFileSize(file.length());
            backupTOList.add(tempFileTO);
        }
        return backupTOList;
    }

    public static List<BackupTO> createBackupElementForDeletedFiles(List<BackUpCrawlFileTO> crawlFileTOs) {
        ArrayList<BackupTO> backupTOList = new ArrayList<BackupTO>();
        for (BackUpCrawlFileTO crawlFileTO : crawlFileTOs) {
            String absPath;
            String filePath = crawlFileTO.getCompletePath();
            File fileToBeBackedUp = new File(filePath);
            String completePath = absPath = fileToBeBackedUp.getAbsolutePath();
            String fileName = fileToBeBackedUp.getName();
            completePath = completePath.substring(0, completePath.length() - (fileName.length() + 1));
            String md5Value = "null";
            BackupTO tempFileTO = new BackupTO();
            tempFileTO.setExists(true);
            tempFileTO.setAbstractFilePath(ObjectUtils.createParentPathForMacOrWin(completePath));
            tempFileTO.setFileName(fileName);
            tempFileTO.setFolder(crawlFileTO.isFolder());
            tempFileTO.setLastModifiedTimestamp(fileToBeBackedUp.lastModified());
            tempFileTO.setMd5checksum(md5Value);
            tempFileTO.setMetaData("null");
            tempFileTO.setClientData(absPath);
            tempFileTO.setBaseFolder(false);
            if (!crawlFileTO.isFolder()) {
                tempFileTO.setFileSize(crawlFileTO.getFileSize());
            } else {
                tempFileTO.setFileSize(0L);
            }
            backupTOList.add(tempFileTO);
        }
        return backupTOList;
    }

    public static String getFileSnapshotPath(String path) {
        String fileSnapshotPath = path;
        if (System.getProperty(OS_NAME).contains("win") && !new File(fileSnapshotPath = System.getProperty("user.home") + StringLiterals.FILE_SEPARATOR + "AppData" + StringLiterals.FILE_SEPARATOR + "Roaming" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBlu" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "Snapshots" + StringLiterals.CONSTANTS_FILE_SEPARATOR + path.substring(0, 1) + "_drive" + path.substring(2)).exists()) {
            fileSnapshotPath = path;
        }
        return fileSnapshotPath;
    }
}

