/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

public class Digest
implements DEREncodable {
    private DEROctetString digest;

    public Digest(byte[] byArray) {
        this.setDigest(byArray);
    }

    public Digest(DEROctetString dEROctetString) {
        this.digest = dEROctetString;
    }

    public Digest(Digest digest) {
        this.digest = digest.digest;
    }

    public static Digest getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Digest) {
            return (Digest)object;
        }
        if (object instanceof DEROctetString) {
            return new Digest((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return Digest.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid Digest");
    }

    public static Digest newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Digest) {
            return new Digest((Digest)object);
        }
        if (object instanceof DEROctetString) {
            return new Digest((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return Digest.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid Digest");
    }

    public byte[] getDigest() {
        return this.digest.getOctets();
    }

    private void setDigest(byte[] byArray) {
        this.digest = new DEROctetString(byArray);
    }

    public DERObject getDERObject() {
        return this.digest;
    }
}

